/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDataFieldItem;
import filenet.vw.toolkit.utils.dialog.VWDataFieldItemRenderer;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VWDataFieldDetailsDialog
extends VWModalDialog
implements ActionListener,
ItemListener {
    private JButton m_closeButton = null;
    private JLabel m_groupName = null;
    private JComboBox m_namesCMB = null;
    private JList m_sourceList = null;
    private Object[] m_selectedItems = null;
    private boolean m_bLocked = false;

    public VWDataFieldDetailsDialog(Frame parentFrame, Object[] selectedItems) {
        super(parentFrame);
        Dimension dim = VWStringUtils.stringToDimension("335,335");
        if (dim == null) {
            dim = new Dimension(300, 300);
        }
        this.setSize(dim.width, dim.height);
        this.setTitle(VWResource.s_fieldNameDetails);
        VWAccessibilityHelper.setAccessibility(this, parentFrame, VWResource.s_fieldNameDetails, VWResource.s_fieldNameDetails);
        this.m_selectedItems = selectedItems;
        this.initLayout();
        if (this.m_namesCMB.getItemCount() > 0) {
            this.m_namesCMB.setSelectedIndex(0);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_closeButton) {
            this.setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable itemSelectable = e.getItemSelectable();
        Object[] objects = itemSelectable.getSelectedObjects();
        if (objects != null && objects.length > 0) {
            this.refreshList();
        }
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
    }

    private void initLayout() {
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        try {
            mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(5, 12, 5, 12);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.fill = 1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            mainPanel.add((Component)this.createNamesPanel(), c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            mainPanel.add((Component)this.createListPanel(), c);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createNamesPanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        try {
            panel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 0, 3);
            gbCons.gridx = 0;
            gbCons.gridwidth = 1;
            gbCons.weightx = 0.0;
            this.m_groupName = new JLabel();
            this.m_groupName.setText(VWResource.s_nameColon);
            panel.add((Component)this.m_groupName, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_groupName, this, VWResource.s_name, VWResource.s_name);
            this.m_namesCMB = new JComboBox();
            this.m_namesCMB.addItemListener(this);
            VWDataFieldItemRenderer renderer = new VWDataFieldItemRenderer();
            this.m_namesCMB.setRenderer(renderer);
            this.initializeComboBox(this.m_namesCMB, this.m_selectedItems);
            gbCons.gridwidth = -1;
            ++gbCons.gridx;
            gbCons.weightx = 1.0;
            panel.add((Component)this.m_namesCMB, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_namesCMB, this, VWResource.s_name, VWResource.s_name);
            VWAccessibilityHelper.setLabelFor(this.m_groupName, this.m_namesCMB);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createListPanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        try {
            panel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(0, 3, 3, 15);
            JLabel label = new JLabel(VWResource.s_usageColon);
            panel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_usage, VWResource.s_usage);
            this.m_sourceList = new JList(new VWSortedListModel());
            gbCons.fill = 1;
            ++gbCons.gridy;
            gbCons.weighty = 1.0;
            panel.add((Component)new JScrollPane(this.m_sourceList), gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_sourceList, this, VWResource.s_usage, VWResource.s_usage);
            VWAccessibilityHelper.setLabelFor(label, this.m_sourceList);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbCons = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 2, 6, 6);
            this.m_closeButton = new JButton(VWResource.s_close);
            this.m_closeButton.addActionListener(this);
            buttonPanel.add((Component)this.m_closeButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_closeButton, this, VWResource.s_close, VWResource.s_close);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void initializeComboBox(JComboBox comboBox, Object[] items) {
        DefaultComboBoxModel dataModel = null;
        this.m_bLocked = true;
        try {
            dataModel = (DefaultComboBoxModel)comboBox.getModel();
            if (dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    dataModel.addElement(items[i]);
                }
            }
            comboBox.setSelectedIndex(-1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_bLocked = false;
    }

    private void refreshList() {
        if (this.m_sourceList == null) {
            return;
        }
        VWSortedListModel listModel = (VWSortedListModel)this.m_sourceList.getModel();
        listModel.removeAllElements();
        Object item = this.m_namesCMB.getSelectedItem();
        if (item != null && item instanceof VWDataFieldItem) {
            Vector aVector = ((VWDataFieldItem)item).getSource();
            if (aVector.size() == 0) {
                return;
            }
            for (int i = 0; i < aVector.size(); ++i) {
                String source = (String)aVector.elementAt(i);
                listModel.addElement(source);
            }
        }
        listModel.sort();
    }
}

